unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ComCtrls, TB97, ExtCtrls, DBNav97, TB97Tlbr, TB97Ctls,
  Buttons;

type
  TfrmMain = class(TForm)
    mnuMain: TMainMenu;
    mnuFile: TMenuItem;
    mnuFileSep1: TMenuItem;
    mnuQuery: TMenuItem;
    mnuQueryNew: TMenuItem;
    mnuQueryOpen: TMenuItem;
    mnuQuerySave: TMenuItem;
    mnuQuerySaveAs: TMenuItem;
		mnuFileExit: TMenuItem;
    mnuQuerySep1: TMenuItem;
    mnuQueryRun: TMenuItem;
    mnuHelp: TMenuItem;
		mnuHelpContents: TMenuItem;
    mnuHelpSep1: TMenuItem;
    mnuHelpAbout: TMenuItem;
    mnuTable: TMenuItem;
    mnuTableOpen: TMenuItem;
    mnuTableExport: TMenuItem;
    mnuEdit: TMenuItem;
    mnuEditCut: TMenuItem;
    mnuEditCopy: TMenuItem;
    mnuEditPaste: TMenuItem;
    mnuEditSelectAll: TMenuItem;
    StatusBar: TStatusBar;
    mnuCreate: TMenuItem;
    mnuCreateAssetType: TMenuItem;
    mnuCreateEventType: TMenuItem;
		mnuCreateSep1: TMenuItem;
    mnuCreateLocation: TMenuItem;
    mnuCreateSystem: TMenuItem;
    mnuCreateAsset: TMenuItem;
    mnuCreateEvent: TMenuItem;
    mnuEditSep1: TMenuItem;
    mnuEditLocation: TMenuItem;
		mnuEditSystem: TMenuItem;
    mnuEditAsset: TMenuItem;
    mnuEditEvent: TMenuItem;
    mnuWindow: TMenuItem;
    mnuWindowSep1: TMenuItem;
    mnuWindowCascade: TMenuItem;
    mnuWindowTileHorizontally: TMenuItem;
    mnuWindowTileVertically: TMenuItem;
    mnuWindowClose: TMenuItem;
    mnuWindowCloseAll: TMenuItem;
    mnuFilePrint: TMenuItem;
    PrinterSetupDialog: TPrinterSetupDialog;
		PrintDialog: TPrintDialog;
    mnuFilePrinterSetup: TMenuItem;
    tbNavigate: TToolbar97;
    dbNav: TDBNavigator97;
    dockTop: TDock97;
    dockLeft: TDock97;
    dockRight: TDock97;
    dockBot: TDock97;
    mnuView: TMenuItem;
    mnuViewNavigationBar: TMenuItem;
		mnuViewQueryBar: TMenuItem;
    mnuViewEditBar: TMenuItem;
    tbEdit: TToolbar97;
    tbEditCut: TToolbarButton97;
    tbEditCopy: TToolbarButton97;
    tbEditPaste: TToolbarButton97;
    tbEditDelete: TToolbarButton97;
    tbQuery: TToolbar97;
    tbQueryNew: TToolbarButton97;
		tbQueryOpen: TToolbarButton97;
    tbQueryRun: TToolbarButton97;
    tbQuerySave: TToolbarButton97;
    tbEditExit: TToolbarButton97;
    mnuQueryExportResults: TMenuItem;
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    Reports1: TMenuItem;
    mnuHelpToDo: TMenuItem;
    mnuReportsCreate: TMenuItem;
    mnuReportsView: TMenuItem;
    mnuHelpTest: TMenuItem;
    mnuFileSep2: TMenuItem;
    mnuFileBackup: TMenuItem;
    mnuFileRestore: TMenuItem;
		procedure FormCreate(Sender: TObject);
    procedure mnuFilePrinterSetupClick(Sender: TObject);
    procedure mnuFilePrintClick(Sender: TObject);
    procedure mnuFileExitClick(Sender: TObject);
		procedure mnuWindowCascadeClick(Sender: TObject);
		procedure mnuWindowTileHorizontallyClick(Sender: TObject);
		procedure mnuWindowTileVerticallyClick(Sender: TObject);
		procedure mnuWindowCloseClick(Sender: TObject);
		procedure mnuWindowCloseAllClick(Sender: TObject);
    procedure mnuHelpContentsClick(Sender: TObject);
    procedure mnuHelpAboutClick(Sender: TObject);
    procedure mnuTableOpenClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mnuQueryNewClick(Sender: TObject);
    procedure mnuQueryRunClick(Sender: TObject);
    procedure tbNavigateClose(Sender: TObject);
    procedure mnuViewNavigationBarClick(Sender: TObject);
    procedure tbEditClose(Sender: TObject);
    procedure mnuViewEditBarClick(Sender: TObject);
    procedure tbQueryClose(Sender: TObject);
    procedure mnuViewQueryBarClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
		procedure mnuQueryClick(Sender: TObject);
		procedure mnuCreateAssetClick(Sender: TObject);
    procedure mnuCreateAssetTypeClick(Sender: TObject);
    procedure mnuCreateLocationClick(Sender: TObject);
    procedure mnuCreateSystemClick(Sender: TObject);
    procedure mnuEditAssetClick(Sender: TObject);
    procedure mnuEditLocationClick(Sender: TObject);
    procedure mnuEditSystemClick(Sender: TObject);
    procedure mnuQuerySaveAsClick(Sender: TObject);
    procedure mnuQueryOpenClick(Sender: TObject);
    procedure mnuQuerySaveClick(Sender: TObject);
    procedure mnuCreateEventTypeClick(Sender: TObject);
    procedure mnuEditPasteClick(Sender: TObject);
    procedure mnuEditCopyClick(Sender: TObject);
    procedure mnuEditCutClick(Sender: TObject);
		procedure mnuEditSelectAllClick(Sender: TObject);
    procedure mnuEditEventClick(Sender: TObject);
    procedure mnuHelpToDoClick(Sender: TObject);
    procedure mnuCreateEventClick(Sender: TObject);
    procedure mnuReportsCreateClick(Sender: TObject);
    procedure mnuHelpTestClick(Sender: TObject);
    procedure mnuFileBackupClick(Sender: TObject);
    procedure mnuFileRestoreClick(Sender: TObject);
    procedure mnuReportsViewClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
		procedure UpdateInterface(Sender: TObject);
	end;

var
	frmMain: TfrmMain;

implementation

uses uSplash, uDataMod, uTables, uQuery, uCreateAsset, uCreateAssetType,
	uCreateLocation, uCreateSystem, uEditAsset, uCreateEventType, uEditEvent,
	uWaterBalanceChart, uPumpEff, uFuelCons, uMaintHist, uCreateEvent,
  uCreateReports, uViewReports, uSelectAsset;
{$R *.DFM}

{ === Utility Procedures =================================}
procedure TfrmMain.UpdateInterface(Sender: TObject);
var
	Children, Tables, Queries: Boolean;
  i: integer;
begin
	Children := (MDIChildCount > 0);
  Tables := False;
  Queries := False;
  i := 0;
	while (i < MDIChildCount) and not Queries and not Tables do
  begin
		If MDIChildren[i] is TfrmAllTables then Tables := True;
		If MDIChildren[i] is TfrmQuery then Queries := True;
    inc(i);
  end;
	mnuWindow.Visible := Children;
  { Edit menu and toolbar }
  mnuEditCut.Enabled := Queries;
  mnuEditCopy.Enabled := Queries;
  mnuEditPaste.Enabled := Queries;
  mnuEditSelectAll.Enabled := Queries;
  tbEditCut.Enabled := Queries;
  tbEditCopy.Enabled := Queries;
  tbEditPaste.Enabled := Queries;
  tbEditDelete.Enabled := Queries;
  { Tables Menu }
  mnuTableExport.Enabled := Tables;
  { Queries menu and toolbar }
  mnuQuerySave.Enabled := Queries;
  mnuQuerySaveAs.Enabled := Queries;
  mnuQueryRun.Enabled := Queries;
	tbQuerySave.Enabled := Queries;
  tbQueryRun.Enabled := Queries;
end;

{ === Event Handlers =====================================}
{ === Form Events ========================================}
{----------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
var
	TableNames: TStringList;
	T1: TMenuItem;
begin
  { Update the interface }
	Screen.OnActiveFormChange := UpdateInterface;
  UpdateInterface(Sender);
	{ Open the database }
  ImpahlaDM.dbMain.Connected := False;
//	ImpahlaDM.dbMain.Params.Clear;
//	ImpahlaDM.dbMain.Params.Values['DATABASE NAME'] := 'C:\My Documents\Wits\AssetMng\Impahla\Motlhabe\Motlhabe.mdb';
//	ImpahlaDM.dbMain.AliasName := 'bdeImpahla';
  ImpahlaDM.dbMain.Connected := True;
	{ Get Table Names and fill Tables|Open menu }
	TableNames := TStringList.Create;
	ImpahlaDM.GetTableNamesNew(ImpahlaDM.dbMain,
		'', False, False, TableNames);
	TableNames.Sort;
	while TableNames.Count > 0 do
	begin
		T1 := TMenuItem.Create(Self);
		T1.Caption := TableNames.Strings[0];
		T1.Name := 'mnuTableOpen' + TableNames.Strings[0];
		T1.OnClick := mnuTableOpenClick;
		mnuTableOpen.Add(T1);
		TableNames.Delete(0);
	end;
	TableNames.Free;
end;

{----------------------------------------------------------}
procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//	ImpahlaDM.dbMain.Connected := False;
	Screen.OnActiveFormChange := nil;
end;

{----------------------------------------------------------}
procedure TfrmMain.FormActivate(Sender: TObject);
begin
	UpdateInterface(Sender);
end;

{ === File Menu ===========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuFileBackupClick(Sender: TObject);
var
	BakName : string;
begin
	SaveDialog.DefaultExt := 'bak';
	SaveDialog.FileName := 'Motlhabe.bak';
	SaveDialog.Filter := 'Backup Files (*.bak)|*.bak';
	If SaveDialog.Execute then
	begin
		BakName := SaveDialog.FileName;
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuFileRestoreClick(Sender: TObject);
var
	RestoreName : string;
begin
	OpenDialog.DefaultExt := 'bak';
	OpenDialog.Filter := 'Backup Files (*.bak)|*.bak';
	If OpenDialog.Execute Then
	begin
		RestoreName := OpenDialog.FileName;
		if MessageDlg('About to restore from backup file' + #10 + #13 +
									'"' + RestoreName + '".' + #10 + #13 +
									'All changes made since the' + #10 + #13 +
									'backup was created will be lost.' + #10 + #13 +
									'Are you sure you want to continue?', mtWarning, [mbYes, mbNo], 0) = mrYes Then
		begin
		end;
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuFilePrinterSetupClick(Sender: TObject);
begin
	PrinterSetupDialog.Execute;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuFilePrintClick(Sender: TObject);
begin
	if PrintDialog.Execute then
		MessageDlg('Printing...',mtInformation, [mbOK], 0);
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuFileExitClick(Sender: TObject);
begin
	mnuWindowCloseAllClick(Sender);
	frmMain.Close;
end;

{ === Edit Menu ===========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuEditCutClick(Sender: TObject);
begin
	if (ActiveMDIChild is TfrmQuery) then
		TfrmQuery(ActiveMDIChild).memoQuery.CutToClipboard;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditCopyClick(Sender: TObject);
begin
	if (ActiveMDIChild is TfrmQuery) then
		TfrmQuery(ActiveMDIChild).memoQuery.CopyToClipboard;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditSelectAllClick(Sender: TObject);
begin
	if (ActiveMDIChild is TfrmQuery) then
		TfrmQuery(ActiveMDIChild).memoQuery.SelectAll;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditPasteClick(Sender: TObject);
begin
	if (ActiveMDIChild is TfrmQuery) then
		TfrmQuery(ActiveMDIChild).memoQuery.PasteFromClipboard;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditLocationClick(Sender: TObject);
begin
	LocCaption := 'Edit Existing Location';
	Application.CreateForm(TfrmCreateLocation, frmCreateLocation);
	frmCreateLocation.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditSystemClick(Sender: TObject);
begin
	SysCaption := 'Edit Existing System';
	Application.CreateForm(TfrmCreateSystem, frmCreateSystem);
	frmCreateSystem.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditAssetClick(Sender: TObject);
begin
	Application.CreateForm(TfrmEditAsset, frmEditAsset);
	frmEditAsset.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuEditEventClick(Sender: TObject);
begin
	Application.CreateForm(TfrmEditEvent, frmEditEvent);
	frmEditEvent.ShowModal;
end;

{ === View Menu ===========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuViewEditBarClick(Sender: TObject);
begin
	if 	mnuViewEditBar.Checked then
	begin
		mnuViewEditBar.Checked := False;
		tbEdit.Visible := False;
	end
	else
	begin
		mnuViewEditBar.Checked := True;
		tbEdit.Visible := True;
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuViewNavigationBarClick(Sender: TObject);
begin
	if 	mnuViewNavigationBar.Checked then
	begin
		mnuViewNavigationBar.Checked := False;
		tbNavigate.Visible := False;
	end
	else
	begin
		mnuViewNavigationBar.Checked := True;
		tbNavigate.Visible := True;
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuViewQueryBarClick(Sender: TObject);
begin
	if 	mnuViewQueryBar.Checked then
	begin
		mnuViewQueryBar.Checked := False;
		tbQuery.Visible := False;
	end
	else
	begin
		mnuViewQueryBar.Checked := True;
		tbQuery.Visible := True;
	end;
end;

{ === Create Menu =========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuCreateLocationClick(Sender: TObject);
begin
	LocCaption := 'Create New Location';
	Application.CreateForm(TfrmCreateLocation, frmCreateLocation);
	frmCreateLocation.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuCreateSystemClick(Sender: TObject);
begin
	SysCaption := 'Create New System';
	Application.CreateForm(TfrmCreateSystem, frmCreateSystem);
	frmCreateSystem.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuCreateAssetClick(Sender: TObject);
begin
	Application.CreateForm(TfrmCreateAsset, frmCreateAsset);
	frmCreateAsset.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuCreateEventClick(Sender: TObject);
begin
	Application.CreateForm(TfrmCreateEvent, frmCreateEvent);
	frmCreateEvent.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuCreateAssetTypeClick(Sender: TObject);
begin
	Application.CreateForm(TfrmCreateAssetType, frmCreateAssetType);
	frmCreateAssetType.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuCreateEventTypeClick(Sender: TObject);
begin
	Application.CreateForm(TfrmCreateEventType, frmCreateEventType);
	frmCreateEventType.ShowModal;
end;

{ === Table Menu ==========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuTableOpenClick(Sender: TObject);
begin
	uTables.tableName := (Sender as TMenuItem).Caption;
	Application.CreateForm(TfrmAllTables, frmAllTables);
	frmAllTables.Show;
end;

{ === Reports Menu ========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuReportsCreateClick(Sender: TObject);
begin
	Application.CreateForm(TfrmCreateReport, frmCreateReport);
	frmCreateReport.ShowModal;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuReportsViewClick(Sender: TObject);
begin
	Application.CreateForm(TfrmViewReports, frmViewReports);
	frmViewReports.ShowModal;
end;

{ === Query Menu ==========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuQueryClick(Sender: TObject);
begin
	if (ActiveMDIChild is TfrmQuery) then
		if TfrmQuery(ActiveMDIChild).SQLQuery.Active then
			mnuQueryExportResults.Enabled := True
		else
			mnuQueryExportResults.Enabled := False
	else
		mnuQueryExportResults.Enabled := False;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuQueryNewClick(Sender: TObject);
begin
	Application.CreateForm(TfrmQuery, frmQuery);
	frmQuery.Show;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuQueryOpenClick(Sender: TObject);
begin
	OpenDialog.DefaultExt := 'sql';
	OpenDialog.Filter := 'Query Files (*.sql)|*.sql|All Files|*.*';
	If OpenDialog.Execute Then
	begin
		QueryName := OpenDialog.FileName;
		Application.CreateForm(TfrmQuery, frmQuery);
		frmQuery.memoQuery.Lines.LoadFromFile(QueryName);
		frmQuery.Show;
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuQuerySaveClick(Sender: TObject);
begin
	if QueryName = '' then
	begin
		mnuQuerySaveAsClick(Sender);
	end
	else
	begin
		frmQuery.memoQuery.Lines.SaveToFile(QueryName);
	end;
	frmQuery.Dirty := False;
	frmQuery.UpdateCaption;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuQuerySaveAsClick(Sender: TObject);
begin
	SaveDialog.DefaultExt := 'sql';
	SaveDialog.Filter := 'Query Files (*.sql)|*.sql|Text Files (*.txt)|*.txt';
	If SaveDialog.Execute then
	begin
		QueryName := SaveDialog.FileName;
		frmQuery.memoQuery.Lines.SaveToFile(QueryName);
		frmQuery.Dirty := False;
		frmQuery.UpdateCaption;
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuQueryRunClick(Sender: TObject);
begin
	with frmQuery.SQLQuery do
	begin
		If Active then
			Close;
		SQL.Clear;
		SQL.Assign(frmQuery.memoQuery.Lines);
		Open;
	end;
end;

{ === Window Menu =========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuWindowCascadeClick(Sender: TObject);
begin
	Cascade;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuWindowTileHorizontallyClick(Sender: TObject);
begin
	TileMode := tbHorizontal;
	Tile;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuWindowTileVerticallyClick(Sender: TObject);
begin
	TileMode := tbVertical;
	Tile;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuWindowCloseClick(Sender: TObject);
begin
	ActiveMDIChild.Close;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuWindowCloseAllClick(Sender: TObject);
var
	i : integer;
begin
	with frmMain do
		for i := MDIChildCount-1 downto 0 do
			MDIChildren[i].Close;
end;

{ === Help Menu ===========================================}
{----------------------------------------------------------}
procedure TfrmMain.mnuHelpContentsClick(Sender: TObject);
var
	Msg: string;
	TempMenu: TMenuItem;
	P : integer;
begin
	if Sender is TMenuItem then
	begin
		TempMenu := (Sender as TMenuItem);
		Msg := TempMenu.Caption;
		While TempMenu.Parent.Caption <> '' do
		begin
			TempMenu := TempMenu.Parent;
			Msg := TempMenu.Caption + '|' + Msg;
		end;
		p := Pos('.',Msg);
		while P > 0 do
		begin
			Delete(Msg, P, 1);
			p := Pos('.',Msg);
		end;
		p := Pos('&',Msg);
		while P > 0 do
		begin
			Delete(Msg, P, 1);
			p := Pos('&',Msg);
		end;
		Msg := 'Sorry, option ' + Msg + ' is not yet available';
		MessageDlg(Msg, mtInformation, [mbOK], 0);
	end
	else
	begin
		Msg := 'Sorry, this option is not yet available';
		MessageDlg(Msg, mtInformation, [mbOK], 0);
	end;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuHelpAboutClick(Sender: TObject);
begin
	uSplash.OpenMode := omAbout;
	frmSplash := TfrmSplash.Create(Application);
	frmSplash.ShowModal;
	frmSplash.Update;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuHelpToDoClick(Sender: TObject);
begin
	uSplash.OpenMode := omToDo;
	frmSplash := TfrmSplash.Create(Application);
	frmSplash.ShowModal;
	frmSplash.Update;
end;

{----------------------------------------------------------}
procedure TfrmMain.mnuHelpTestClick(Sender: TObject);
var
	lGAID: LongInt;
	lID : String;
begin
	if SelectAsset(lGAID, lID) then
		MessageDlg('GAID: ' + IntToStr(lGAID) + ' ID: ' + lID, mtInformation, [mbOK], 0)
	else
		MessageDlg('No asset selected', mtInformation, [mbOK], 0)
end;

{ === Other Event Procedures ==============================}
{----------------------------------------------------------}
procedure TfrmMain.tbNavigateClose(Sender: TObject);
begin
	mnuViewNavigationBar.Checked := False;
end;

{----------------------------------------------------------}
procedure TfrmMain.tbEditClose(Sender: TObject);
begin
	mnuViewEditBar.Checked := False;
end;

{----------------------------------------------------------}
procedure TfrmMain.tbQueryClose(Sender: TObject);
begin
	mnuViewQueryBar.Checked := False;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}
{==========================================================}
