unit uSelectAsset;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, RxLookup, Db, DBTables, Buttons;

type
  TfrmSelectAsset = class(TForm)
    gboxAssetID: TGroupBox;
    lblAssetID: TLabel;
    lblDirections: TLabel;
    medAssetID: TMaskEdit;
    gboxLocation: TGroupBox;
    tblRegions: TTable;
    dsRegions: TDataSource;
    rxdbcomboRegions: TRxDBLookupCombo;
    lblRegions: TLabel;
    lblSites: TLabel;
    rxdbcomboSites: TRxDBLookupCombo;
    tblSites: TTable;
    dsSites: TDataSource;
    gboxType: TGroupBox;
    lblEquip1: TLabel;
    lblEquip2: TLabel;
    rxdbcomboEquip1: TRxDBLookupCombo;
    rxdbcomboEquip2: TRxDBLookupCombo;
    gboxSystem: TGroupBox;
    lblSys1: TLabel;
    lblSys2: TLabel;
    rxdbcomboSys1: TRxDBLookupCombo;
		rxdbcomboSys2: TRxDBLookupCombo;
    lblSys3: TLabel;
    rxdbcomboSys3: TRxDBLookupCombo;
    tblSys1: TTable;
    dsSys1: TDataSource;
		tblSys2: TTable;
    dsSys2: TDataSource;
    tblSys3: TTable;
    dsSys3: TDataSource;
    tblEquip1: TTable;
    dsEquip1: TDataSource;
    tblEquip2: TTable;
    dsEquip2: TDataSource;
    bitbtnOK: TBitBtn;
    bitbtnCancel: TBitBtn;
    gboxNumber: TGroupBox;
    lblNumber: TLabel;
    rxdbcomboNumber: TRxDBLookupCombo;
    sqlNumber: TQuery;
    dsNumber: TDataSource;
    sqlCheckGAID: TQuery;
    procedure rxdbcomboRegionsChange(Sender: TObject);
    procedure medAssetIDChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bitbtnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	frmSelectAsset: TfrmSelectAsset;
	uGAID: LongInt;
	uID: String;

	function SelectAsset(var GAID: longint; var ID: string) : boolean;

implementation

{$R *.DFM}
var
	UserInput: boolean;

function SelectAsset(var GAID: longint; var ID: string) : boolean;
begin
	Application.CreateForm(TfrmSelectAsset, frmSelectAsset);
	if frmSelectAsset.ShowModal = mrOK then
	begin
		GAID := uGAID;
		ID := uID;
		Result := True;
	end
	else
		Result := False;
end;

{----------------------------------------------------------}
procedure TfrmSelectAsset.rxdbcomboRegionsChange(Sender: TObject);

var
	strTemp: string;
	OpenSQL: Boolean;

	Procedure UpdateMEdit(var Str: String; Combo: TRxDBLookupCombo; I, C: Integer);
	var j: byte;
	begin
		If VarType(Combo.KeyValue) <> $0001 then
		begin
			Delete(Str, I, C);
			Insert(Combo.KeyValue, Str, I);
			sqlNumber.Params[Combo.Tag].Text := String(Combo.KeyValue);
		end
		Else
		begin
			OpenSQL := False;
			Delete(Str, I, C);
			For j := 0 to C - 1 Do
				Insert(' ', Str, I + j);
		end;
	end;

begin
//	MessageDlg((Sender as TComponent).Name, mtInformation, [mbOK], 0);
	If UserInput then
	begin
		strTemp := medAssetID.Text;
		sqlNumber.Close;
		OpenSQL := True;
		Case (Sender as TComponent).Tag of
		0	: UpdateMEdit(strTemp, rxdbcomboRegions, 1, 1);
		1	: UpdateMEdit(strTemp, rxdbcomboSites, 2, 3);
		2	: UpdateMEdit(strTemp, rxdbcomboSys1, 8, 1);
		3	: UpdateMEdit(strTemp, rxdbcomboSys2, 9, 1);
		4	: UpdateMEdit(strTemp, rxdbcomboSys3, 10, 1);
		5	: UpdateMEdit(strTemp, rxdbcomboEquip1, 12, 1);
		6	: UpdateMEdit(strTemp, rxdbcomboEquip2, 13, 1);
		end; {case}
		If OpenSQL Then sqlNumber.Open;
		try
			if (sqlNumber.Active) AND (VarType(rxdbcomboNumber.KeyValue) <> $0001) then
			begin
				Delete(strTemp, 14, 3);
				strTemp := strTemp + Format('%.3d', [Integer(rxdbcomboNumber.KeyValue)]);
			end;
		except
			On EVariantError do
			begin
				MessageDlg('ERROR: Please fill in all fields' + #10 + #13 +
									 'before selecting the asset number.', mtError, [mbOK], 0);
			end;
		end;
		UserInput := False;
		medAssetID.EditText := strTemp;
		UserInput := True;
	end;
end;

{----------------------------------------------------------}
procedure TfrmSelectAsset.medAssetIDChange(Sender: TObject);

	Procedure UpdateCombo(Combo: TRxDBLookupCombo; I, C: Integer);
	begin
		If Pos(' ', Copy(medAssetID.Text, I, C)) > 0 Then
			Combo.ResetField
		else
		begin
			Combo.KeyValue := Copy(medAssetID.Text, I, C);
			sqlNumber.Params[Combo.Tag].Text := String(Combo.KeyValue);
		end;
	end;

begin
//	MessageDlg(medAssetID.Text, mtInformation, [mbOK], 0);
	If UserInput Then
	begin
		UserInput := False;
		sqlNumber.Close;
		UpdateCombo(rxdbcomboRegions, 1, 1);
		UpdateCombo(rxdbcomboSites, 2, 3);
		UpdateCombo(rxdbcomboSys1, 8, 1);
		UpdateCombo(rxdbcomboSys2, 9, 1);
		UpdateCombo(rxdbcomboSys3, 10, 1);
		UpdateCombo(rxdbcomboEquip1, 12, 1);
		UpdateCombo(rxdbcomboEquip2, 13, 1);
//		UpdateCombo(rxdbcomboNumber, 14, 3);
		sqlNumber.Open;
		UserInput := True;
	end;
end;

{----------------------------------------------------------}
procedure TfrmSelectAsset.FormCreate(Sender: TObject);
begin
	UserInput := True;
	tblRegions.Open;
	tblSites.Open;
	tblSys1.Open;
	tblSys2.Open;
	tblSys3.Open;
	TblEquip1.Open;
	tblEquip2.Open;
end;

{----------------------------------------------------------}
procedure TfrmSelectAsset.bitbtnOKClick(Sender: TObject);
var
	Count: Longint;
begin
	ModalResult := mrCancel; // Make sure we don't return a value if an error occurs
	with sqlCheckGAID do
	begin
		try
			ParamByName('RegionCode').Text := Copy(medAssetID.Text, 1, 1);
			ParamByName('SiteCode').Text := Copy(medAssetID.Text, 2, 3);
			ParamByName('Sys1').Text := Copy(medAssetID.Text, 8, 1);
			ParamByName('Sys2').Text := Copy(medAssetID.Text, 9, 1);
			ParamByName('Sys3').Text := Copy(medAssetID.Text, 10, 1);
			ParamByName('Equip1').Text := Copy(medAssetID.Text, 12, 1);
			ParamByName('Equip2').Text := Copy(medAssetID.Text, 13, 1);
			ParamByName('Num').Text := Copy(medAssetID.Text, 14, 3);
		except
			On EVariantError do
			begin
				MessageDlg('ERROR: Please fill in all fields.', mtError, [mbOK], 0);
				ModalResult := mrNone;
				Exit;
			end;
		end;
		Open;
		Count := RecordCount;
	end;
	if Count = 0 then
	begin
		MessageDlg('ERROR: No matching records found.'+#10+#13+
			'Please correct the asset details!', mtError, [mbOK], 0);
		ModalResult := mrNone;
	end;
	if Count > 1 then
	begin
		MessageDlg('ERROR: Multiple records found.'+#10+#13+
			'Please check the database!', mtError, [mbOK], 0);
		ModalResult := mrNone;
	end;
	if Count = 1 then
	begin
		uGAID := sqlCheckGAID.FieldValues['GAID'];
		uID := medAssetID.Text;
    ModalResult := mrOK;
  end;
  sqlCheckGAID.Close;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}

