unit uTables;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls, DBCtrls, Grids, DBGrids, StdCtrls, Db, DBTables, Buttons;

type
	TfrmAllTables = class(TForm)
		dbgridAllTables: TDBGrid;
    tblAllTables: TTable;
    dsAllTables: TDataSource;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure tblAllTablesBeforeClose(DataSet: TDataSet);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	frmAllTables: TfrmAllTables;
	TableName: string;

implementation

{$R *.DFM}

uses uMain, uDataMod;

{----------------------------------------------------------}
procedure TfrmAllTables.FormCreate(Sender: TObject);
begin
	Caption := 'Table: ' + TableName;
	tblAllTables.TableName := TableName;
	tblAllTables.Active := True;
	frmMain.dbNav.DataSource := dsAllTables;
end;

{----------------------------------------------------------}
procedure TfrmAllTables.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	tblAllTables.Active := False;
	frmMain.StatusBar.SimpleText := '';
	frmMain.dbNav.DataSource := Nil;
	Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmAllTables.tblAllTablesBeforeClose(DataSet: TDataSet);
begin
	{ Check for unposted data }
	if tblAllTables.State = dsEdit then
		if MessageDlg('You have not posted your changes to the table' +
			#13 + #10 + 'Do you  want to save the changes now?',
			mtWarning, [mbYes, mbNo], 0) = mrYes then
		begin
			tblAllTables.Post;
		end
		else
		begin
			tblAllTables.Cancel;
		end;
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}

