unit uViewReports;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, DBTables, RxLookup, Grids, DBGrids, Buttons, MemTable,
	ComCtrls, ExtCtrls, TeEngine, Series, TeeProcs, Chart, DBChart, ToolEdit,
	Mask;

type
	TfrmViewReports = class(TForm)
		tblReports: TTable;
		dsReports: TDataSource;
		sqlMain: TQuery;
		tblInitial: TTable;
		tblCrossTab: TTable;
		tblFinal: TTable;
		batchmoveMain: TBatchMove;
		dsFinal: TDataSource;
		Panel1: TPanel;
		lblReportName: TLabel;
		rxdbcomboName: TRxDBLookupCombo;
		bitbtnView: TBitBtn;
		pgcontViewReports: TPageControl;
		tabTable: TTabSheet;
		dbgridMain: TDBGrid;
		tabChart: TTabSheet;
		bitbtnDone: TBitBtn;
		DBChart1: TDBChart;
		Series1: TBarSeries;
		Series2: TBarSeries;
		lblFilterID: TLabel;
		medFilterID: TMaskEdit;
		dedStart: TDateEdit;
		dedEnd: TDateEdit;
		lblStartDate: TLabel;
		lblEndDate: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure bitbtnViewClick(Sender: TObject);
		procedure rxdbcomboNameChange(Sender: TObject);
		procedure medFilterIDChange(Sender: TObject);
		procedure dedStartChange(Sender: TObject);
	private
		{ Private declarations }
		function GetFilterString: string;
	public
		{ Public declarations }
	end;

var
	frmViewReports: TfrmViewReports;

implementation

{$R *.DFM}
function TfrmViewReports.GetFilterString: string;
begin
	Result := '';
	// Region Code
	if Copy(medFilterID.Text, 1,1) <> ' ' then
		Result := 'RegionCode='''+Copy(medFilterID.Text, 1,1)+'''';
	// Site Code
	if Pos(' ', Copy(medFilterID.Text, 2,3)) = 0 then
		if Result = '' then
			Result := 'SiteCode='''+Copy(medFilterID.Text, 2,3)+''''
		else
			Result := Result + ' AND SiteCode='''+Copy(medFilterID.Text, 2,3)+'''';
	// Sys1
	if Copy(medFilterID.Text, 8,1) <> ' ' then
		if Result = '' then
			Result := 'Sys1='''+Copy(medFilterID.Text, 8,1)+''''
		else
			Result := Result + ' AND Sys1='''+Copy(medFilterID.Text, 8,1)+'''';
	// Sys2
	if Copy(medFilterID.Text, 9,1) <> ' ' then
		if Result = '' then
			Result := 'Sys2='''+Copy(medFilterID.Text, 9,1)+''''
		else
			Result := Result + ' AND Sys2='''+Copy(medFilterID.Text, 9,1)+'''';
	// Sys3
	if Copy(medFilterID.Text, 10,1) <> ' ' then
		if Result = '' then
			Result := 'Sys3='''+Copy(medFilterID.Text, 10,1)+''''
		else
			Result := Result + ' AND Sys3='''+Copy(medFilterID.Text, 10,1)+'''';
	// Equip1
	if Copy(medFilterID.Text, 12,1) <> ' ' then
		if Result = '' then
			Result := 'Equip1='''+Copy(medFilterID.Text, 12,1)+''''
		else
			Result := Result + ' AND Equip1='''+Copy(medFilterID.Text, 12,1)+'''';
	// Equip2
	if Copy(medFilterID.Text, 13,1) <> ' ' then
		if Result = '' then
			Result := 'Equip2='''+Copy(medFilterID.Text, 13,1)+''''
		else
			Result := Result + ' AND Equip2='''+Copy(medFilterID.Text, 13,1)+'''';
	// Start Date
	if Pos(' ', dedStart.Text) = 0 then
		if Result = '' then
			Result := 'DateTime>'''+dedStart.Text+''''
		else
			Result := Result + ' AND DateTime>'''+dedStart.Text+'''';
	// End Date
	if Pos(' ', dedEnd.Text) = 0 then
		if Result = '' then
			Result := 'DateTime<'''+dedEnd.Text+''''
		else
			Result := Result + ' AND DateTime<'''+dedEnd.Text+'''';
//	MessageDlg(Result, mtInformation, [mbOK], 0);
end;


{----------------------------------------------------------}
procedure TfrmViewReports.FormCreate(Sender: TObject);
begin
	tblReports.Open;
	tblReports.First;
	rxdbcomboName.KeyValue := tblReports.FieldValues['ReportID'];
	pgcontViewReports.ActivePage := tabTable;
	frmViewReports.ActiveControl := rxdbcomboName;
end;

{----------------------------------------------------------}
procedure TfrmViewReports.FormClose(Sender: TObject;
	var Action: TCloseAction);
begin
	tblReports.Close;
	tblInitial.Close;
	tblCrosstab.Close;
	tblFinal.Close;
	Action := caFree;
end;

{----------------------------------------------------------}
procedure TfrmViewReports.bitbtnViewClick(Sender: TObject);
	procedure MoveData (Table: TTable);
	var
		i: integer;
		TempField: TFieldDef;
	begin
		Table.Close;
		sqlMain.Open;
		Table.FieldDefs.Clear;
		for i := 0 to sqlMain.FieldCount - 1 do
		begin
			TempField := sqlMain.FieldDefs.Items[i];
			if TempField.DataType = ftAutoInc then
				Table.FieldDefs.Add(TempField.Name, ftInteger, TempField.Size, TempField.Required)
			Else
				Table.FieldDefs.Add(TempField.Name, TempField.DataType, TempField.Size, TempField.Required)
		end;
		Table.CreateTable;
		batchmoveMain.Destination := Table;
		batchmoveMain.Execute;
		Table.Open;
		sqlMain.Close;
	end;
var
	i: integer;
begin
	Screen.Cursor := crSQLWait;
	// Set up Filter string
	tblFinal.Filter := GetFilterString;
	tblFinal.Filtered := (tblFinal.Filter <> '');
	// Run Queries
	sqlMain.SQL.Text := tblReports.FieldValues['InitialQuery'];
	MoveData(tblInitial);
	sqlMain.SQL.Text := tblReports.FieldValues['CrossTabQuery'];
	MoveData(tblCrossTab);
	sqlMain.SQL.Text := tblReports.FieldValues['FinalQuery'];
	MoveData(tblFinal);
	with dbgridMain do
	begin
		for i := 0 to Columns.Count - 1 do
			if Columns.Items[i].Width > 75 then
				Columns.Items[i].Width := 75;
	end;
	Screen.Cursor := crDefault;
end;

{----------------------------------------------------------}
procedure TfrmViewReports.rxdbcomboNameChange(Sender: TObject);
begin
	tblFinal.Close;
end;

{----------------------------------------------------------}
procedure TfrmViewReports.medFilterIDChange(Sender: TObject);
begin
	tblFinal.Filter := GetFilterString;
	tblFinal.Filtered := (tblFinal.Filter <> '');
end;

{----------------------------------------------------------}
procedure TfrmViewReports.dedStartChange(Sender: TObject);
begin
	tblFinal.Filter := GetFilterString;
	tblFinal.Filtered := (tblFinal.Filter <> '');
end;

{----------------------------------------------------------}
end.
{----------------------------------------------------------}
